import ast, compiler

def assign(names, values):
  assert len(names)==len(values)

  parrot_name=[]
  for i in range(0,len(names)):
    parrot_name.append(ast.lookup(names[i].name))

  regs=[]
  for i in range(0,len(names)-1):
    regs.append(ast.temp())
    assert names[i].flags == "OP_ASSIGN" ## TODO
    ast.output("\t%s = new PerlInt" % regs[-1])
    ast.output("\t%s = %s" % (regs[-1], ast.evaluate(values[i])))

  assert names[-1].flags == "OP_ASSIGN" ## TODO

  if values[-1].__class__==compiler.ast.Sub and \
     values[-1].left.__class__ == compiler.ast.Name and \
     values[-1].left.name == names[-1].name and \
     values[-1].right.__class__ == compiler.ast.Const and \
     values[-1].right.value == 1:
    ast.output("\tdec %s" % parrot_name[-1])
  else:
    ast.output("\t%s = %s" % (parrot_name[-1], ast.evaluate(values[-1])))

  for i in range(len(names)-2,-1,-1):
    ast.output("\t%s = %s" % (parrot_name[i], regs.pop()))

def process(node):
  if len(node.nodes)==1:

    if node.nodes[0].__class__ == compiler.ast.AssName:

      assign(node.nodes,[node.expr])

    elif node.nodes[0].__class__ == compiler.ast.AssList:
      assert node.expr.__class__ == compiler.ast.Tuple

      assign(node.nodes[0].nodes, node.expr.nodes)

    elif node.nodes[0].__class__ == compiler.ast.AssTuple:
      assert node.expr.__class__ == compiler.ast.Tuple

      assign(node.nodes[0].nodes, node.expr.nodes)

    else:
      print len(node.nodes)
      print node.nodes, node.expr
      ast.fail("Assign unimplemented")
  else:
    ast.fail("Assign unimplemented")
