import ast,compiler
def process(node):
  if node.list.__class__ in (compiler.ast.Tuple, compiler.ast.List):
    assert node.assign.__class__ == compiler.ast.AssName
    assert node.assign.flags == "OP_ASSIGN"
    
    list = ast.temp()
    ast.output("\t%s = new ResizablePMCArray" % list)
    ast.output("\t%s = %d" % (list, len(node.list.nodes)))
    for i in range(0,len(node.list.nodes)):
      ast.output("\t%s[%d] = %s" % (list, i, ast.evaluate(node.list.nodes[i])))
      
    iter = ast.temp()
    ast.output("\t%s = iter %s" % (iter, list))

    l1 = ast.label()
    l2 = ast.label()
    ast.push_loop((l1,l2))

    ast.output(l1 + ":")
    ast.output("\tunless %s goto %s" % (iter,l2))
    ast.output("\t%s = shift %s" % (ast.lookup(node.assign.name, False),iter))
    ast.execute(node.body)
    ast.output("\tgoto " + l1)
    ast.output(l2 + ":")

    ast.pop_loop()

  else:
    print node
    ast.fail("For unimplemented")
