import ast, compiler

inverse = {
  "!=":"eq",
  "<":"ge",
  "<=":"gt",
  "==":"ne",
  ">":"le",
  ">=":"lt",
}

def unless(test, label):
  if test.__class__ == compiler.ast.Compare and \
     test.expr.__class__ == compiler.ast.Name and \
     len(test.ops) == 1:
    ast.output("\t%s %s, %s, %s" % (inverse[test.ops[0][0]],test.expr.name,ast.evaluate(test.ops[0][1]), label))
  else:
    ast.output("\tunless %s goto %s" % (ast.evaluate(test), label))

def process(node):

  endif=ast.label()
  for test in node.tests[:-2]:
    label=ast.label()
    unless(test[0], label)
    ast.execute(test[1])
    ast.output("\tgoto " + endif)
    ast.output(label+":")

  if node.else_:
    label=ast.label()
    unless(node.tests[-1][0], label)
    ast.execute(node.tests[-1][1])
    ast.output("\tgoto " + endif)
    ast.output(label+":")
    ast.execute(node.else_)
  else:
    unless(node.tests[-1][0], endif)
    ast.execute(node.tests[-1][1])

  ast.output(endif+":")
